<?php
class WC_Settings_Tab_Demo {
    
    public static
    function init() {
        add_filter('woocommerce_settings_tabs_array', __CLASS__.
            '::add_settings_tab', 50);
        add_action('woocommerce_settings_tabs_settings_tab_demo', __CLASS__.
            '::settings_tab');
        add_action('woocommerce_update_options_settings_tab_demo', __CLASS__.
            '::update_settings');
    }

    
    public static
    function add_settings_tab($settings_tabs) {
        $settings_tabs['settings_tab_demo'] = __('eCourierz', 'woocommerce-settings-tab-demo');
        return $settings_tabs;
    }
    
    public static
    function settings_tab() {
        woocommerce_admin_fields(self::get_settings());
    }
    
    public static
    function update_settings() {
        woocommerce_update_options(self::get_settings());
    }
    
    public static
    function get_settings() {
        $settings = array(
            'section_title' => array(
                'name' => __('API key settings', 'woocommerce-settings-tab-demo'),
                'type' => 'title',
                'desc' => '',
                'id' => 'wc_settings_tab_demo_section_title'
            ),
            'partner_code' => array(
                'name' => __('PARTNER-CODE', 'woocommerce-settings-tab-demo'),
                'type' => 'text',
                'desc' => __('Enter your partner code.eg.,The code is ship.ecourierz.com or demo.ecourierz.com etc. If you have queries regarding the code, please check the welcome email from eCourierz.com for this partner code. Additional Note: If your store is Rendered over HTTP , PARTNER_CODE to be used is sellers.eshipz.com', 'woocommerce-settings-tab-demo'),
                'id' => 'partner_code'
            ),
            'api_token' => array(
                'name' => __('X-API-Token', 'woocommerce-settings-tab-demo'),
                'type' => 'text',
                'desc' => __('Your eCourierz API key. ', 'woocommerce-settings-tab-demo'),
                'id' => 'x-api-token'
            ),
            'is_test_booking' => array(
                'name' => __('Is Testing Mode', 'woocommerce-settings-tab-demo'),
                'type' => 'checkbox',
                'desc' => __('Enables Testing Mode. Check this option for Testing Purposes. Disable this option once you are for Placing Actual Shipments with eCourierz', 'woocommerce-settings-tab-demo'),
                'id' => 'is_test_booking'
            ),
            'section_end' => array(
                'type' => 'sectionend',
                'id' => 'wc_settings_tab_demo_section_end'
            )
        );
        return apply_filters('wc_settings_tab_demo_settings', $settings);
    }
}
WC_Settings_Tab_Demo::init();


?>