<?php
/*
 *
 * Plugin Name: eCourierz - Powering eCommerce Logistics
 * Plugin URI: http://www.ecourierz.com/ecommerce-logistics-solutions/
 * Description: Integrated Multi-carrier Shipping services through eCourierz.
 * Author: eCourierz
 * Author URI: http://www.ecourierz.com/ecommerce-logistics-solutions/
 * Version: 1.0.1.4
 * Copyright 2019 Planet Express Innovations Pvt Ltd
 * email : devops@ecourierz.com
 *
*/

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ){
    

	if ( ! class_exists( 'WC_Ecz' ) ) {

		/**
		 * Localisation
		 **/
    
        load_plugin_textdomain( 'wc_ecourierz', false, dirname( plugin_basename( __FILE__ ) ) . '/' );

        function wpb_adding_scripts() {
			wp_enqueue_script( 'bootstrap', plugins_url( '/js/bootstrap.min.js', __FILE__ ), array('jquery') );
            wp_enqueue_script( 'woo-ecourierz', plugins_url( '/js/woo-ecourierz.js?v=1.0.1.3', __FILE__ ), array('jquery') );
            //wp_enqueue_script( 'woocommerce', '/wp-content/plugins/eshipz_wp/js/jquery-3.1.0.js', array('jquery') );
        }

        add_action('admin_enqueue_scripts', 'wpb_adding_scripts');


		class WC_Ecz {

			public function __construct() {
                
				// called only after woocommerce has finished loading


				// called just before the woocommerce template functions are included
                
				// indicates we are running the admin

				if ( is_admin() ) {

					if(	strpos($_SERVER['REQUEST_URI'], 'edit.php') !== false && 
                   		strpos($_SERVER['QUERY_STRING'], 'post_type=shop_order') !== false )
					{
                        include_once('template.php');
                    }

                    add_action( 'woocommerce_init', array( &$this, 'woocommerce_loaded' ) );

                    // called after all plugins have loaded
                    add_action( 'plugins_loaded', array( &$this, 'plugins_loaded' ) );

                    add_action( 'init', array( &$this, 'include_template_functions' ),1 );

                    add_filter( 'woocommerce-settings-tab-demo', 'some_tab_settings', 10, 2 );

                    function some_tab_settings( $settings, $current_section ) {
                        if ($current_section == 'settings_tab_demo') {
                            echo "settings here";
                        } else {
                            return $settings;
                        }
                    }


                    add_filter( 'manage_edit-shop_order_columns', 'shop_order_columns' );
                    function shop_order_columns($columns){
                        $new_columns = (is_array($columns)) ? $columns : array();
                       
                        //edit this for you column(s)
                        //$new_columns['rate'] = 'eCourierz';
                        //stop editing
                        $rate = array( 'rate' => 'eCourierz' );
                         //$phone = array( 'phone' => 'Phone' );
   						 $position = 9;
    					 $new_columns1 = array_slice( $new_columns, 0, $position, true ) +  $rate;

    					 return array_merge( $new_columns1, $new_columns );

                        //return $new_columns1;

                    }


                    add_action( 'manage_shop_order_posts_custom_column', 'shop_order_posts_custom_column', 2 );
                    function shop_order_posts_custom_column($column){
                        global $post, $the_order, $woocommerce,$product;

                        if ( empty( $the_order ) || (( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->id : $the_order->get_id() != $post->ID )) {
                            $the_order = new WC_Order( $post->ID );
                        }
                        // $id = $post->ID;
                        // $billing_address = $the_order->get_address();
                        //stop editing
                        if ( 'rate' == $column ) {

                            $order_id = $the_order->get_order_number();
                            $lstatus = get_post_meta( $order_id, '_label_status', true ) || get_post_meta( $order_id, 'label_status', true );
                            $bstatus = get_post_meta( $order_id, '_booking_status', true ) || get_post_meta( $order_id, 'booking_status', true );

                            $order_total = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->get_total() : $the_order->get_total();

                            if($lstatus == 1 && $bstatus == 1)
                            {
                                // If Label Status & booking Status Exists, fetch the following custom attributes
                                $awbs = get_post_meta($order_id, 'subpackage_awb', true);
                                $urls = get_post_meta($order_id, 'subpackages_label', true);
								$ordid = get_post_meta( $order_id, 'ecz_id', true );
                                ?>
                                <a type="button" class="detailbtn" count="<?php echo $order_total; ?>" label_link="<?php echo get_post_meta($order_id, 'label_link', true); ?>" cod_label="<?php echo get_post_meta($order_id, 'cod_label', true); ?>" trackno="<?php echo get_post_meta( $order_id, 'tracking_no', true ); ?>" bookingid="<?php echo get_post_meta( $order_id, 'ecz_id', true ); ?>" awb="<?php echo $awbs ;?>" url="<?php echo $urls; ?>"><span style="cursor:pointer;">Details</span></a>
								<?php //$a1 = get_option('partner_code');
                                //$b1 = get_option('x-api-token');  ?><p>
								<a type="button" id="ecz_id" href="#"  class="ecz_order" key1="<?php echo get_option('x-api-token'); ?>" code1="<?php echo get_option('partner_code'); ?>" ecz_ref="<?php echo get_post_meta( $order_id, 'ecz_id', true ); ?>"><span style="cursor:pointer;">Track</span></a></p>
									
								
								
							<?php  
							}
                            else if($lstatus == 0 && $bstatus == 1)
                            {
                                // If Label Status is empty & booking Status Exists, show link to Generate the Labels
                                $a = get_option('partner_code');
                                $b = get_option('x-api-token');
                                $is_test_booking = get_option('is_test_booking');
                                ?>
                                <span class="hidden" id = "custom_data" is_test_booking="<?php echo $is_test_booking; ?>" key="<?php echo $b; ?>" code="<?php echo $a; ?>"></span>
                                <button type="button" id="" class="btn btn-info glabelbtn" oid="<?php echo $order_id;?>"  code="<?php echo get_option('partner_code'); ?>" value="<?php echo get_post_meta( $order_id, 'ecz_id', true ); ?>">Generate Label</button>
								<?php
                            }
                            else {
                                $a = get_option('partner_code');
								$b = get_option('x-api-token');
								$is_test_booking = get_option('is_test_booking');
                                ?>
                                <div>
                                <span class="hidden" id = "custom_data" is_test_booking="<?php echo $is_test_booking; ?>" key="<?php echo $b; ?>" code="<?php echo $a; ?>"></span>
                                <?php
                                // If Label Status & booking Status are empty, set the following custom attributes
                                add_post_meta( $order_id, '_label_status', '0', true );
                                add_post_meta( $order_id, '_booking_status', '0', true );
                                add_post_meta( $order_id, 'ecz_id', null,true);
                                add_post_meta( $order_id, 'tracking_no', null,true);
                                add_post_meta( $order_id, 'label_link', null,true);
                                add_post_meta( $order_id, 'subpackage_awb', null,true);
                                add_post_meta( $order_id, 'cod_label', null,true);
								add_post_meta( $order_id, 'subpackages_label', null,true);
								
								// apply_filters( 'is_protected_meta', true, '_label_status', null );

                                $order_id 	= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->id : $the_order->get_id();
                                $order_date = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->order_date : $the_order->get_date_created();
                                $billing_first_name = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_first_name : $the_order->get_billing_first_name();
                                $billing_last_name 	= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_last_name : $the_order->get_billing_last_name();
                                $billing_email 		= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_email : $the_order->get_billing_email();
                                $billing_phone 		= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_phone : $the_order->get_billing_phone();
                                $billing_company  = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_company : $the_order->get_billing_company();
                                $billing_address_1  = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_address_1 : $the_order->get_billing_address_1();
                                $billing_address_2  = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_address_2 : $the_order->get_billing_address_2();
                                $billing_state		= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_state : $the_order->get_billing_state() ;
                                $billing_city		= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_city : $the_order->get_billing_city();
                                $billing_postcode	= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_postcode : $the_order->get_billing_postcode();
                                $billing_country	= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_country : $the_order->get_billing_country();
                                $shipping_first_name = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->shipping_first_name 	: $the_order->get_shipping_first_name();
                                $shipping_last_name  = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->shipping_last_name 	: $the_order->get_shipping_last_name();
                                $shipping_company  = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->shipping_company 	: $the_order->get_shipping_company();
                                $shipping_address_1  = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->shipping_address_1 	: $the_order->get_shipping_address_1();
                                $shipping_address_2  = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->shipping_address_2 	: $the_order->get_shipping_address_2();
                                $shipping_city 		 = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->shipping_city 		: $the_order->get_shipping_city();
                                $shipping_country 	 = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->shipping_country 	: $the_order->get_shipping_country();
                                $shipping_state 	 = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->shipping_state 		: $the_order->get_shipping_state();
                                $shipping_postcode 	 = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->shipping_postcode    : $the_order->get_shipping_postcode();
                                $billing_email 		 = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->billing_email 		: $the_order->get_billing_email();
                                $customer_note 		 = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->customer_note 		: $the_order->get_customer_note();
                                $order_date 		= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $the_order->order_date : $the_order->get_date_created();
//
//                              $product_type 		= ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $product->product_type : $product->get_type();

                                // Generate Services & Booking Object Structures
//                                foreach ( $the_order->get_items() as $item ) {
//                                    $product = wc_get_product($item['product_id']);
//                                    if(is_bool($product) != true){
//
//                                    }
//                                }
                                /////////////////////////
                                $wt = array();
                                $cont = array();
                                $i = 0;
                                $j = 0;
                                $sum = 0;
                                $_count = 0;
                                $is_cod = get_post_meta( $order_id, '_payment_method', true );
                                foreach ( $the_order->get_items() as $item ) {
                                    $product_id = $item['product_id'];
                                    $sum = $item['qty'] + $sum;
                                    $product = wc_get_product($product_id);
                                    if(is_bool($product) == true)
                                    {

                                    } else {
//                                        echo $product;
//
                                        $price = $product->get_price();
                                        $length1 = $product->get_length();
                                        $width1 = $product->get_width();
                                        $height1 = $product->get_height();
                                        $weight1 = $product->get_weight();
                                        $weight = wc_get_weight($weight1, 'g');
                                        $length = wc_get_dimension($length1, 'cm');
                                        $width = wc_get_dimension($width1, 'cm');
                                        $height = wc_get_dimension($height1, 'cm');
                                        $content = $product->get_title();
                                        $total = $length . "," . $width . "," . $height . "," . ($weight * $item['qty']) . "," . $price;
//
//                                        while ($item['qty']--) {
                                            $wt[$i] = $total;
                                            $cont[$i] = $content;
                                            $i++;
//                                        }
                                    }
                                    $_count += 1;
//
                                }
                                $k = str_replace(array( '[', ']', '"' ), '', json_encode($wt));
                                $str = implode (",", $cont);

                                ?>
                                <a type="button" id="ratebtn" is_cod="<?php echo $is_cod ?>" count="<?php echo $_count; ?>" firstname="<?php echo $shipping_first_name ?  $shipping_first_name : $billing_first_name;?>" lastname="<?php echo $shipping_last_name ? $shipping_last_name : $billing_last_name;?>" company="<?php echo $shipping_company ? $shipping_company : $billing_company;?>" shipaddone="<?php echo $shipping_first_name ? $shipping_address_1 : $billing_address_1;?>" shipaddtwo="<?php echo $shipping_first_name ? $shipping_address_2 : $billing_address_2;?>" city="<?php echo $shipping_first_name ? $shipping_city : $billing_city;?>" state="<?php echo $shipping_first_name ? $shipping_state : $billing_state;?>" country="<?php echo $shipping_first_name ? $shipping_country : $billing_country;?>" content="<?php echo $str;?>"  pin="<?php echo $shipping_first_name ? $shipping_postcode : $billing_postcode;?>" oid="<?php echo $order_id;?>"  data="<?php echo $k;?>" site_name="<?php echo get_bloginfo(); ?>" phone ="<?php echo $billing_phone; ?>" class="rtbtn"><span style="cursor:pointer;">Get rate<span></a>
                                <?php
                            }
                            ?>
                            </div>
                            <?php
                        }
                    }

                    include( 'settings_new.php' );
					//include('track.php');
                    // include('wallet-refill.php');
				}
				// indicates we are being served over ssl
				if ( is_ssl() ) {
					// ...
				}
				// take care of anything else that needs to be done immediately upon plugin instantiation, here in the constructor
			}

			/**
			 * Take care of anything that needs woocommerce to be loaded.  
			 * For instance, if you need access to the $woocommerce global
			 */
			public function woocommerce_loaded() {
				// ...
			}

			/**
			 * Take care of anything that needs all plugins to be loaded
			 */
			public function plugins_loaded() {
				// ...
			}
			/**
			 * Override any of the template functions from woocommerce/woocommerce-template.php 
			 * with our own template functions file
			 */
			public function include_template_functions() {
				//include( 'template.php' );
			}
		}
              
		// finally instantiate our plugin class and add it to the set of globals
		$GLOBALS['wc_ecz'] = new WC_Ecz();
	}
}
// This below code is for client side track button
function sv_add_my_account_order_actions( $actions, $order ) {
$order_id = $order->get_order_number();
$ordid1= get_post_meta( $order_id, 'ecz_id', true );
$code=base64_encode(json_encode(get_option('partner_code')));
$api=base64_encode(json_encode(get_option('x-api-token')));
//echo $code;
//echo $api;
$track_url = "/wp-content/plugins/". dirname( plugin_basename( __FILE__ ) ) ."/track.php/?order_id=". $order_id . "&order=". $ordid1 . "&c=" . $code . "&a=" . $api . "";
if($ordid1!=null) {
	?>
	<a class="woocommerce-button button track" style="font-size:smaller;" class="" href="<?php echo $track_url ?>" target="_blank">Track</a>
	<?php
   /* $actions['Track'] = array(
        // adjust URL as needed
        'url'  => 'localhost/wordpress/wp-content/plugins/eshipz_wp-5/track.php/?&order=' . get_post_meta( $order_id, 'ecz_id', true ).'&c='.$code.'&a='.$api,
        'name' => __( 'Track', 'my-textdomain' ),
    );*/
	?>
	<?php
}
	  return $actions;
}
add_filter( 'woocommerce_my_account_my_orders_actions', 'sv_add_my_account_order_actions', 10, 2 );
?>